/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.spawner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.ICreatureTFC;
import net.dries007.tfc.objects.entity.animal.EntityAlpacaTFC;
import net.dries007.tfc.objects.entity.animal.EntityCamelTFC;
import net.dries007.tfc.objects.entity.animal.EntityChickenTFC;
import net.dries007.tfc.objects.entity.animal.EntityCowTFC;
import net.dries007.tfc.objects.entity.animal.EntityDonkeyTFC;
import net.dries007.tfc.objects.entity.animal.EntityDuckTFC;
import net.dries007.tfc.objects.entity.animal.EntityGoatTFC;
import net.dries007.tfc.objects.entity.animal.EntityGrouseTFC;
import net.dries007.tfc.objects.entity.animal.EntityHorseTFC;
import net.dries007.tfc.objects.entity.animal.EntityLlamaTFC;
import net.dries007.tfc.objects.entity.animal.EntityMuskOxTFC;
import net.dries007.tfc.objects.entity.animal.EntityOcelotTFC;
import net.dries007.tfc.objects.entity.animal.EntityPigTFC;
import net.dries007.tfc.objects.entity.animal.EntityQuailTFC;
import net.dries007.tfc.objects.entity.animal.EntitySheepTFC;
import net.dries007.tfc.objects.entity.animal.EntityWolfTFC;
import net.dries007.tfc.objects.entity.animal.EntityYakTFC;
import net.dries007.tfc.objects.entity.animal.EntityZebuTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.dries007.tfc.world.classic.spawner.AnimalRespawnWorldData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber(modid="tfc")
public final class WorldEntitySpawnerTFC {
    public static final Map<Class<? extends EntityLiving>, Supplier<Integer>> LIVESTOCK = new HashMap<Class<? extends EntityLiving>, Supplier<Integer>>();

    public static void init() {
        EnumCreatureType.MONSTER.field_75606_e = ConfigTFC.General.DIFFICULTY.mobSpawnCount;
        EnumCreatureType.CREATURE.field_75606_e = ConfigTFC.General.DIFFICULTY.animalSpawnCount;
    }

    @SubscribeEvent
    public static void onLivestockRespawn(LivingSpawnEvent.SpecialSpawn event) {
        World worldIn = event.getWorld();
        EntityLiving entity = (EntityLiving)event.getEntity();
        event.getWorld().func_180494_b(new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ())).func_76747_a(EnumCreatureType.CREATURE);
        if (LIVESTOCK.containsKey(entity.getClass())) {
            event.setResult(Event.Result.ALLOW);
            AnimalRespawnWorldData data = AnimalRespawnWorldData.get(worldIn);
            ChunkPos pos = new ChunkPos(new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ()));
            long lastSpawnTick = data.getLastRespawnTick((Entity)entity, pos);
            long deltaTicks = CalendarTFC.PLAYER_TIME.getTicks() - lastSpawnTick;
            long cooldown = LIVESTOCK.get(entity.getClass()).get().intValue();
            if (lastSpawnTick <= 0L || cooldown <= deltaTicks) {
                data.setLastRespawnTick((Entity)entity, pos, CalendarTFC.PLAYER_TIME.getTicks());
                int centerX = (int)event.getX();
                int centerZ = (int)event.getZ();
                int diameterX = 16;
                int diameterZ = 16;
                WorldEntitySpawnerTFC.doGroupSpawning(EntityRegistry.getEntry(entity.getClass()), worldIn, centerX, centerZ, diameterX, diameterZ, worldIn.field_73012_v);
            }
        }
    }

    public static void performWorldGenSpawning(World worldIn, Biome biomeIn, int centerX, int centerZ, int diameterX, int diameterZ, Random randomIn) {
        BlockPos chunkBlockPos = new BlockPos(centerX, 0, centerZ);
        float temperature = ClimateTFC.getAvgTemp(worldIn, chunkBlockPos);
        float rainfall = ChunkDataTFC.getRainfall(worldIn, chunkBlockPos);
        float floraDensity = ChunkDataTFC.getFloraDensity(worldIn, chunkBlockPos);
        float floraDiversity = ChunkDataTFC.getFloraDiversity(worldIn, chunkBlockPos);
        ForgeRegistries.ENTITIES.getValuesCollection().stream().filter(x -> {
            Entity ent;
            if (ICreatureTFC.class.isAssignableFrom(x.getEntityClass()) && (ent = x.newInstance(worldIn)) instanceof ICreatureTFC) {
                int weight = ((ICreatureTFC)ent).getSpawnWeight(biomeIn, temperature, rainfall, floraDensity, floraDiversity);
                return weight > 0 && randomIn.nextInt(weight) == 0;
            }
            return false;
        }).findFirst().ifPresent(entityEntry -> WorldEntitySpawnerTFC.doGroupSpawning(entityEntry, worldIn, centerX, centerZ, diameterX, diameterZ, randomIn));
    }

    private static void doGroupSpawning(EntityEntry entityEntry, World worldIn, int centerX, int centerZ, int diameterX, int diameterZ, Random randomIn) {
        ArrayList<EntityLiving> group = new ArrayList<EntityLiving>();
        EntityLiving creature = (EntityLiving)entityEntry.newInstance(worldIn);
        if (!(creature instanceof ICreatureTFC)) {
            return;
        }
        ICreatureTFC creatureTFC = (ICreatureTFC)creature;
        int fallback = 5;
        int individuals = Math.max(1, creatureTFC.getMinGroupSize()) + randomIn.nextInt(creatureTFC.getMaxGroupSize() - Math.max(0, creatureTFC.getMinGroupSize() - 1));
        while (individuals > 0) {
            int j = centerX + randomIn.nextInt(diameterX);
            int k = centerZ + randomIn.nextInt(diameterZ);
            BlockPos blockpos = worldIn.func_175672_r(new BlockPos(j, 0, k));
            creature.func_70012_b((double)((float)j + 0.5f), (double)blockpos.func_177956_o(), (double)((float)k + 0.5f), randomIn.nextFloat() * 360.0f, 0.0f);
            if (creature.func_70601_bi()) {
                if (ForgeEventFactory.canEntitySpawn((EntityLiving)creature, (World)worldIn, (float)((float)j + 0.5f), (float)blockpos.func_177956_o(), (float)((float)k + 0.5f), null) == Event.Result.DENY) {
                    if (--fallback <= 0) break;
                    continue;
                }
                fallback = 5;
                worldIn.func_72838_d((Entity)creature);
                group.add(creature);
                creature.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)creature)), null);
                if (--individuals <= 0) continue;
                creature = (EntityLiving)entityEntry.newInstance(worldIn);
                creatureTFC = (ICreatureTFC)creature;
                continue;
            }
            if (--fallback > 0) continue;
            break;
        }
        creatureTFC.getGroupingRules().accept(group, randomIn);
    }

    static {
        LIVESTOCK.put(EntityAlpacaTFC.class, () -> ConfigTFC.Animals.ALPACA.elder * 24000);
        LIVESTOCK.put(EntityCamelTFC.class, () -> ConfigTFC.Animals.CAMEL.elder * 24000);
        LIVESTOCK.put(EntityChickenTFC.class, () -> ConfigTFC.Animals.CHICKEN.elder * 24000);
        LIVESTOCK.put(EntityCowTFC.class, () -> ConfigTFC.Animals.COW.elder * 24000);
        LIVESTOCK.put(EntityDonkeyTFC.class, () -> ConfigTFC.Animals.DONKEY.elder * 24000);
        LIVESTOCK.put(EntityDuckTFC.class, () -> ConfigTFC.Animals.DUCK.elder * 24000);
        LIVESTOCK.put(EntityGoatTFC.class, () -> ConfigTFC.Animals.GOAT.elder * 24000);
        LIVESTOCK.put(EntityGrouseTFC.class, () -> ConfigTFC.Animals.GROUSE.elder * 24000);
        LIVESTOCK.put(EntityHorseTFC.class, () -> ConfigTFC.Animals.HORSE.elder * 24000);
        LIVESTOCK.put(EntityLlamaTFC.class, () -> ConfigTFC.Animals.LLAMA.elder * 24000);
        LIVESTOCK.put(EntityMuskOxTFC.class, () -> ConfigTFC.Animals.MUSKOX.elder * 24000);
        LIVESTOCK.put(EntityOcelotTFC.class, () -> ConfigTFC.Animals.OCELOT.elder * 24000);
        LIVESTOCK.put(EntityPigTFC.class, () -> ConfigTFC.Animals.PIG.elder * 24000);
        LIVESTOCK.put(EntityQuailTFC.class, () -> ConfigTFC.Animals.QUAIL.elder * 24000);
        LIVESTOCK.put(EntitySheepTFC.class, () -> ConfigTFC.Animals.SHEEP.elder * 24000);
        LIVESTOCK.put(EntityWolfTFC.class, () -> ConfigTFC.Animals.WOLF.elder * 24000);
        LIVESTOCK.put(EntityYakTFC.class, () -> ConfigTFC.Animals.YAK.elder * 24000);
        LIVESTOCK.put(EntityZebuTFC.class, () -> ConfigTFC.Animals.ZEBU.elder * 24000);
    }
}

